import React from "react";

export const metadata = {
  title: "যোগাযোগ || Weekly Ajkal",
  description:
    "বাংলাদেশ ও বিশ্বসংবাদ সম্পর্কে সর্বশেষ আপডেট জানুন। এখানে পাবেন খেলাধুলা, রাজনীতি, চাকরি, বিনোদন, স্বাস্থ্য, লাইফস্টাইল এবং আরও অনেক কিছু।",
  keywords:
    "আজকাল, খবর, আপডেট, বাংলাদেশ, বিশ্বসংবাদ, খেলাধুলা, রাজনীতি, বিনোদন, স্বাস্থ্য, লাইফস্টাইল",
  openGraph: {
    type: "website",
    url: "https://www.ajkal.us/about",
    title: "সাপ্তাহিক আজকাল :: Weekly Ajkal",
    description:
      "বাংলাদেশ ও বিশ্বসংবাদ সম্পর্কে সর্বশেষ আপডেট জানুন। এখানে পাবেন খেলাধুলা, রাজনীতি, চাকরি, বিনোদন, স্বাস্থ্য, লাইফস্টাইল এবং আরও অনেক কিছু।",
    images: [
      {
        url: "https://ajkal.us/img/settings/placeholder.jpg",
        width: 1200,
        height: 630,
        alt: "সাপ্তাহিক আজকাল এর চিত্র",
      },
    ],
    site_name: "আজকাল",
  },
  twitter: {
    card: "summary_large_image",
    title: "সাপ্তাহিক আজকাল :: Weekly Ajkal",
    description:
      "বাংলাদেশ ও বিশ্বসংবাদ সম্পর্কে সর্বশেষ আপডেট জানুন। এখানে পাবেন খেলাধুলা, রাজনীতি, চাকরি, বিনোদন, স্বাস্থ্য, লাইফস্টাইল এবং আরও অনেক কিছু।",
    images: ["https://ajkal.us/img/settings/placeholder.jpg"],
  },
  canonicalUrl: "https://www.ajkal.us/about", // Ensure this is the correct URL
};

const page = () => {
  return (
    <div>
      <div className="container">
        <div className="row my-5">
          <div className="col-lg-6 english-text">
            <div style={{ borderBottom: "2px solid var(--secondary)" }}>
              <h1 className="english-text">About Us</h1>
            </div>
            {/* Content In English */}
            <div className="pt-3 english-text">
              <div className="english-text pb-4">
                Welcome to Weekly Ajkal, your premier source for insightful news
                and captivating stories. Established with a vision to provide a
                comprehensive perspective on the events shaping our world,
                Weekly Ajkal stands as a beacon of journalistic integrity and
                excellence in {"today's"} media landscape.
              </div>
              <div className="english-text pb-4">
                At Weekly Ajkal, we believe in the transformative power of
                information. As your trusted weekly companion, we endeavor to
                bring you the latest developments and thought-provoking analyses
                from around the globe. Our dedicated team of journalists,
                writers, and editors are committed to delivering accurate,
                balanced, and impactful reporting that informs, educates, and
                inspires.
              </div>
              <div className="english-text pb-4">
                Our coverage spans a wide spectrum of topics, ranging from
                breaking news and current affairs to in-depth features and
                cultural highlights. Whether {"you're"} interested in politics,
                business, technology, arts, or sports, Weekly Ajkal has
                something for everyone. We strive to capture the pulse of
                society, amplifying diverse voices and perspectives to foster
                greater understanding and empathy.
              </div>
              <div className="english-text pb-4">
                As advocates for transparency and accountability, we hold
                ourselves to the highest standards of ethical journalism. Our
                commitment to truth and accuracy is unwavering, ensuring that
                our readers can rely on us as a trusted source of information in
                an era of misinformation and fake news.
              </div>
              <div className="english-text pb-4">
                Weekly Ajkal is more than just a news outlet; {"it's"} a
                community of engaged and informed individuals who share a
                passion for knowledge and insight. We invite you to join us on
                this journey as we explore the complexities of our world,
                celebrate the richness of human experience, and seek to make a
                positive impact in our communities.
              </div>
              <div className="english-text pb-4">
                Thank you for choosing Weekly Ajkal as your weekly window to the
                world. Together, {"let's"} embark on a journey of discovery,
                enlightenment, and growth with each edition.
              </div>
            </div>
          </div>
          <div className="col-lg-6">
            <div style={{ borderBottom: "2px solid var(--secondary)" }}>
              <h1 className="text-muted fw-bold secondary-color">
                সাপ্তাহিক আজকাল এর নিয়ে
              </h1>
            </div>
            {/* Content Start In Bangla */}
            <div className="pt-3">
              <div className="english-text pb-4">
                সাপ্তাহিক আজকাল হলো দেশের একটি স্বনামধন্য মিডিয়া প্রতিষ্ঠান যা
                সাংবাদিকতার মান, পেশাদারিত্ব ও নিরপেক্ষতার জন্য পরিচিত। আমাদের
                লক্ষ্য হলো বর্তমান ঘটনা এবং সামাজিক বিষয়াবলীর প্রতি গভীর
                বিশ্লেষণ এবং সঠিক তথ্য প্রদান করা।
              </div>
              <div className="english-text pb-4">
                আমরা বিশ্বাস করি যে, তথ্যের শক্তি সমাজের উন্নতি সাধনে
                গুরুত্বপূর্ণ ভূমিকা পালন করে। আমাদের পেশাদার সাংবাদিক এবং লেখকদল
                বিশ্বব্যাপী ঘটমান বিষয়াবলী সম্পর্কে সঠিক, নিরপেক্ষ এবং
                প্রভাবশালী প্রতিবেদন প্রদানে প্রতিশ্রুতিবদ্ধ।
              </div>
              <div className="english-text pb-4">
                সাপ্তাহিক আজকাল এর সামগ্রী বিস্তৃত পরিসরে বিভিন্ন বিষয়বস্তু
                তুলে ধরে, যা রাজনৈতিক, ব্যবসায়িক, প্রযুক্তিগত, সাংস্কৃতিক এবং
                ক্রীড়া বিষয়ক খবর নিয়ে আলোচনা করে। আমাদের উদ্দেশ্য হল সমাজের
                প্রতিটি স্তরের কণ্ঠস্বর তুলে ধরা এবং বিশদ বিশ্লেষণ প্রদান করা।
              </div>
              <div className="english-text pb-4">
                আমরা জবাবদিহিতা ও স্বচ্ছতার প্রতি আমাদের প্রতিশ্রুতি বজায় রেখে
                চলি। আমাদের প্রতিবেদনগুলো সঠিক এবং নির্ভরযোগ্য তথ্য প্রদান করে
                যাতে আমাদের পাঠকরা কোন প্রকার ভুল তথ্য থেকে রক্ষা পেতে পারে।
              </div>
              <div className="english-text pb-4">
                সাপ্তাহিক আজকাল শুধু একটি সংবাদ মাধ্যম নয়; এটি একটি সচেতন ও
                জ্ঞানমুখী সম্প্রদায়ের অংশ যেখানে আমরা একসাথে বিশ্বের জটিলতা
                বিশ্লেষণ করে, মানবিক অভিজ্ঞতার সমৃদ্ধি উদযাপন করে এবং আমাদের
                সম্প্রদায়ে ইতিবাচক প্রভাব ফেলতে চেষ্টা করি।
              </div>
              <div className="english-text pb-4">
                আমাদের সাথে যুক্ত হওয়ার জন্য ধন্যবাদ। আসুন, আমরা একসাথে প্রতিটি
                সংস্করণের মাধ্যমে আবিষ্কার, শিক্ষালাভ এবং উন্নয়নের যাত্রা শুরু
                করি।
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default page;
