"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.debounce = debounce;
exports.insertScript = insertScript;
exports.isReactElement = isReactElement;
exports.removeResources = removeResources;
exports.removeScript = removeScript;
exports.shallowComparison = shallowComparison;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }
function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
function insertScript(src, id, parentElement) {
  var script = window.document.createElement('script');
  script.async = true;
  script.src = src;
  script.id = id;
  parentElement.appendChild(script);
  return script;
}
function removeScript(id, parentElement) {
  var script = window.document.getElementById(id);
  if (script) parentElement.removeChild(script);
}
function removeResources() {
  // Remove the bundles that the Disqus scripts add to prevent duplicated resources when navigating between pages
  var disqusResources = window.document.querySelectorAll(
  // eslint-disable-next-line max-len
  'link[href*="disquscdn.com/next/embed"], link[href*="disquscdn.com/next/recommendations"], link[href*="disqus.com/next/config.js"], script[src*="disquscdn.com/next/embed"], script[src*="disqus.com/count-data.js"], iframe[title="Disqus"]');
  disqusResources.forEach(function (el) {
    return el.remove();
  });
}
function debounce(func, wait, runOnFirstCall) {
  var timeout;
  return function () {
    var context = this; // eslint-disable-line consistent-this
    var args = arguments;
    var deferredExecution = function deferredExecution() {
      timeout = null;
      if (!runOnFirstCall) func.apply(context, args);
    };
    var callNow = runOnFirstCall && !timeout;
    window.clearTimeout(timeout);
    timeout = setTimeout(deferredExecution, wait);
    if (callNow) func.apply(context, args);
  };
}
function isReactElement(element) {
  if (_react["default"].isValidElement(element)) {
    return true;
  } else if (Array.isArray(element)) {
    return element.some(function (value) {
      return _react["default"].isValidElement(value);
    });
  }
  return false;
}
function shallowComparison(currentProps, nextProps) {
  // Perform a comparison of all props, excluding React Elements, to prevent unnecessary updates
  var propNames = new Set(Object.keys(currentProps), Object.keys(nextProps)); // eslint-disable-line no-undef
  var _iterator = _createForOfIteratorHelper(propNames),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var name = _step.value;
      if (_typeof(currentProps[name]) === 'object') {
        if (shallowComparison(currentProps[name], nextProps[name])) return true;
      } else if (currentProps[name] !== nextProps[name] && !isReactElement(currentProps[name])) {
        return true;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return false;
}