"use client";
import { useState, useEffect } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Scrollbar, A11y } from "swiper/modules"; // removed Pagination
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/scrollbar";

import FallbackImages from "@/utility/FallBackImage/FallBackImages";
import Loading from "../../../app/loading";

const EpaperSingleSlide = ({ epaperList }) => {
  const [loadedImages, setLoadedImages] = useState([]); // track loaded images
  const [loading, setLoading] = useState(true);

  // Load first 5 images immediately
  useEffect(() => {
    const firstFive = epaperList.slice(0, 5).map((_, idx) => idx);
    setLoadedImages(firstFive);
    if (firstFive.length > 0) setLoading(false); // hide preloader after first batch
  }, [epaperList]);

  const handleSlideChange = (swiper) => {
    const currentIdx = swiper.activeIndex % epaperList.length;
    if (!loadedImages.includes(currentIdx)) {
      setLoadedImages((prev) => [...prev, currentIdx]);
    }
  };

  if (loading) return <Loading />;

  if (!epaperList || epaperList.length === 0)
    return <div>No epapers available</div>;

  return (
    <Swiper
      modules={[Navigation, Scrollbar, A11y]} // Pagination removed
      spaceBetween={20}
      slidesPerView={1}
      loop={true}
      navigation
      scrollbar={false}
      onSlideChange={handleSlideChange}
    >
      {epaperList.map((epaper, index) => (
        <SwiperSlide key={index}>
          <div className="card rounded-1 border-0 feature-cards">
            {loadedImages.includes(index) ? (
              <FallbackImages
                src={`https://ajkal.us/img/epaper/${epaper.epaper_image}`}
                alt={epaper.name}
                title={epaper.news_title}
                className="img-fluid"
                width={1325}
                height={2048}
              />
            ) : (
              <div
                style={{
                  width: "100%",
                  height: "400px",
                  background: "#f0f0f0",
                }}
              />
            )}
          </div>
        </SwiperSlide>
      ))}
    </Swiper>
  );
};

export default EpaperSingleSlide;
