"use client";
import React from "react";
import Link from "next/link";
import Image from "next/image"; // Import Image component
import "./Banner.css";

const BannerSlide = ({ bannerList }) => {
  // Get the latest banner data (first item in the array)
  const latestBanner = bannerList.length > 0 ? bannerList[0] : null;

  return (
    <div>
      {latestBanner ? (
        <Link href={`/news-detail/${latestBanner?.id}`}>
          <div className="banner-slide rounded-2">
            <div className="banner-overlay">
              {/* Use the next/image tag for the image instead of background */}
              <div className="banner-image-container rounded-4">
                <Image
                  src={`https://ajkal.us/img/news/${latestBanner.title_img}`}
                  alt={latestBanner.news_title}
                  title={latestBanner.news_title}
                  className="image-scale"
                  width={1920} // Set width as per your requirement
                  height={500} // Set height as per your requirement
                  layout="intrinsic" // Use intrinsic for responsive images
                />
                <div className="banner-content-container">
                  <div className="banner-content">
                    <h2 className="mb-3 banner-title">
                      {latestBanner.news_title}
                    </h2>
                  </div>
                </div>
              </div>
              <div className="banner-overlay-bottom"></div>
            </div>
          </div>
        </Link>
      ) : (
        <div>No epapers available</div>
      )}
    </div>
  );
};

export default BannerSlide;
