"use client";

import { useEffect, useState } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Autoplay, A11y } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/autoplay";
import FallbackImages from "@/utility/FallBackImage/FallBackImages";
import Link from "next/link";
import "./ReletedNews.css";

const RelatedSingle = ({ singleNewsDetails }) => {
  const [relatedNews, setRelatedNews] = useState([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const fetchRelatedNews = async () => {
      if (!singleNewsDetails?.category_id) return;

      const route = `https://backoffice.ajkal.us/category-news/${singleNewsDetails.category_id}`;
      try {
        const res = await fetch(route, { cache: "no-cache" });
        if (!res.ok) throw new Error(`Failed to fetch: ${res.statusText}`);
        const data = await res.json();
        setRelatedNews(data?.data || []);
      } catch (error) {
        console.error("Error fetching related news:", error);
      } finally {
        setLoading(false);
      }
    };

    fetchRelatedNews();
  }, [singleNewsDetails?.category_id]);

  if (loading) {
    return (
      <div className="text-center py-5">
        <div className="spinner-border text-primary" role="status" />
      </div>
    );
  }

  if (!relatedNews.length) {
    return (
      <p className="text-center py-4">No featured items for this category.</p>
    );
  }

  return (
    <Swiper
      modules={[Navigation, Autoplay, A11y]}
      spaceBetween={20}
      loop={true}
      autoplay={{ delay: 3000, disableOnInteraction: false }}
      breakpoints={{
        640: { slidesPerView: 1 },
        768: { slidesPerView: 2 },
        1024: { slidesPerView: 3 },
      }}
    >
      {relatedNews.map((slide) => (
        <SwiperSlide key={slide.id}>
          <Link
            href={`/news-detail/${slide.id}`}
            className="text-decoration-none"
          >
            <div className="card h-100 shadow-none border-0">
              <FallbackImages
                src={`https://ajkal.us/img/news/${slide.title_img}`}
                alt={slide.news_title}
                className="card-img-top rounded-top"
                width={400}
                height={250}
                style={{ objectFit: "cover", height: "200px" }}
              />
              <div className="card-body">
                <h5 className="card-title text-dark" title={slide.news_title}>
                  {slide.news_title}
                </h5>
                <p className="card-text text-muted text-truncate">
                  {slide.news_short_brief}
                </p>
              </div>
            </div>
          </Link>
        </SwiperSlide>
      ))}
    </Swiper>
  );
};

export default RelatedSingle;
