"use client"; // Necessary for client-side interactivity

import React from "react";
import toast from "react-hot-toast";
import { FaCopy } from "react-icons/fa";

const CopyUrlButton = () => {
  const copyUrlToClipboard = () => {
    const currentUrl = window.location.href;
    navigator.clipboard.writeText(currentUrl).then(() => {
      toast.success("URL copied to clipboard!");
    });
  };

  return (
    <button
      className="btn btn-sm me-2 text-white border" style={{backgroundColor: "var(--main)"}}
      onClick={copyUrlToClipboard}
      title="Copy News URL"
      aria-label="Copy URL"
    >
      <FaCopy />
    </button>
  );
};

export default CopyUrlButton;
