export default async function categoryAllNewsApi() {
  const route = `https://backoffice.ajkal.us/news-category?_=${Date.now()}`;

  try {
    const data = await fetch(route, { cache: 'no-cache' });

    if (!data.ok) {
      throw new Error(`Failed to fetch data: ${data.status} ${data.statusText}`);
    }

    const categoryNewsData = await data.json();
    return categoryNewsData?.data;
  } catch (error) {
    console.error("Error fetching category news:", error);
    return null;
  }
}
