export default async function dhormoCatNewsApi() {
  const route = `https://backoffice.ajkal.us/category-news/8?_=${Date.now()}`;

  try {
    const data = await fetch(route, { cache: 'no-cache' });

    if (!data.ok) {
      throw new Error(`Failed to fetch data: ${data.status} ${data.statusText}`);
    }

    const dhormoData = await data.json();
    return dhormoData?.data;
  } catch (error) {
    console.error("Error fetching Dhormo category news:", error);
    return null;
  }
}
