export default async function saraBanglaCatNewsApi() {
  const route = `https://backoffice.ajkal.us/category-news/5?_=${Date.now()}`;

  try {
    const data = await fetch(route, { cache: 'no-cache' });

    if (!data.ok) {
      throw new Error(`Failed to fetch data: ${data.status} ${data.statusText}`);
    }

    const saraBanglaData = await data.json();
    return saraBanglaData?.data;
  } catch (error) {
    console.error("Error fetching Sara Bangla category news:", error);
    return null;
  }
}
