export default async function saraBissoCatNewsApi() {
  const route = `https://backoffice.ajkal.us/category-news/4?_=${Date.now()}`;

  try {
    const data = await fetch(route, { cache: 'no-cache' });

    if (!data.ok) {
      throw new Error(`Failed to fetch data: ${data.status} ${data.statusText}`);
    }

    const saraBissoData = await data.json();
    return saraBissoData?.data;
  } catch (error) {
    console.error("Error fetching Sara Bisso category news:", error);
    return null;
  }
}
