export default async function spotlightNewsApi() {
  const route = `https://backoffice.ajkal.us/spotlight-news?_=${Date.now()}`; // prevent caching

  try {
    const response = await fetch(route, { cache: 'no-cache' });

    if (!response.ok) {
      throw new Error(`Failed to fetch data: ${response.status} ${response.statusText}`);
    }

    const json = await response.json();
    return json?.data;
  } catch (error) {
    console.error("Error fetching spotlight news:", error);
    return null;
  }
}
