export default async function latestNewsApi() {
  const route = `https://backoffice.ajkal.us/latest-news?_=${Date.now()}`; // cache-busting query

  try {
    const response = await fetch(route, { cache: 'no-cache' });

    if (!response.ok) {
      throw new Error(`Failed to fetch data: ${response.status} ${response.statusText}`);
    }

    const json = await response.json();
    return json?.data;
  } catch (error) {
    console.error("Error fetching latest news:", error);
    return null;
  }
}
